<?php
/**
 * Plugin Name:       Google Apps Login Premium
 * Plugin URI:        https://wp-glogin.com/
 * Description:       Simple secure login for WordPress through users' Google Apps accounts (uses secure OAuth2, and MFA if enabled)
 * Requires at least: 5.5
 * Requires PHP:      7.2
 * Version:           3.5.0
 * Author:            WP Glogin Team
 * Author URI:        https://wp-glogin.com/
 * Text Domain:       googleappslogin-premium
 * Domain Path:       /lang
 * Network:           true
 *
 * Google Apps Login is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Google Apps Login is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Google Apps Login. If not, see <https://www.gnu.org/licenses/>.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'commercial_google_apps_login' ) ) {
	global $gal_core_already_exists;
	$gal_core_already_exists = true;
} else {
	require_once( plugin_dir_path( __FILE__ ) . '/core/commercial_google_apps_login.php' );
}

class premium_google_apps_login extends commercial_google_apps_login {

	protected $PLUGIN_VERSION        = '3.5.0';
	protected $WPGLOGIN_GA_STORE_URL = 'https://wp-glogin.com';
	protected $WPGLOGIN_GA_ITEM_NAME = 'Google Apps Login for WordPress Premium';
	protected $WPGLOGIN_GA_ITEM_ID   = 149;

	// Singleton
	private static $instance = null;

	public static function get_instance() {

		if ( null === self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}


	// AUX FUNCTIONS

	protected function get_eddsl_optname() {

		return 'eddsl_gal_premium_ls';
	}

	public function my_plugin_basename() {

		$basename = plugin_basename( __FILE__ );

		if ( __FILE__ === '/' . $basename ) { // Maybe due to symlink
			$basename = basename( dirname( __FILE__ ) ) . '/' . basename( __FILE__ );
		}

		return $basename;
	}

	protected function my_plugin_url() {

		$basename = plugin_basename( __FILE__ );

		if ( __FILE__ === '/' . $basename ) { // Maybe due to symlink
			return plugins_url() . '/' . basename( dirname( __FILE__ ) ) . '/';
		}

		// Normal case (non symlink)
		return plugin_dir_url( __FILE__ );
	}

}

// Global accessor function to singleton
function galpremiumGoogleAppsLogin() {

	return premium_google_apps_login::get_instance();
}

// Initialise at least once
galpremiumGoogleAppsLogin();

if ( ! function_exists( 'GoogleAppsLogin' ) ) {
	function GoogleAppsLogin() {

		return galpremiumGoogleAppsLogin();
	}
}
